/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.menu;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessMIDlet;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.menu.Menu;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class MenuCanvas
extends Canvas
implements CommandListener {
    private int startIndex;
    private int endIndex;
    private final Menu[] menus;
    private Menu currentMenu;
    private int currentMenuIndex = 0;
    private Image backgroundImage;
    private Image bufferedImage;
    private Graphics bufferedGraphics;
    private Image tileImage;
    private int tileColumns;
    private boolean inProcessKey;

    public MenuCanvas(Menu[] menuArray, int n) {
        this.menus = menuArray;
        this.currentMenuIndex = n;
        if (!this.isDoubleBuffered()) {
            this.bufferedImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.bufferedGraphics = this.bufferedImage.getGraphics();
        }
        try {
            this.tileImage = Image.createImage((String)"/images/MenuTiles.png");
            this.tileColumns = this.tileImage.getWidth() / 20;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.backgroundImage = Image.createImage((String)"/images/Background.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentMenu = menuArray[n];
        this.addCommand(FitnessCommands.SELECT_COMMAND);
        this.addCommand(FitnessCommands.EXIT_COMMAND);
        this.setCommandListener(this);
        this.resetMenu();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Graphics graphics2 = graphics;
        if (!this.isDoubleBuffered()) {
            graphics2 = this.bufferedGraphics;
        }
        graphics2.setColor(0xFFFFFF);
        graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.backgroundImage != null) {
            graphics2.drawImage(this.backgroundImage, 0, 0, 20);
        }
        graphics2.setColor(0);
        graphics2.setFont(FitnessObjects.MENU_TITLE_FONT);
        graphics2.drawString(this.currentMenu.title, 2, 2, 20);
        int n3 = 2;
        int n4 = 2 + FitnessObjects.MENU_TITLE_FONT.getHeight() + 3 + 3;
        int n5 = this.getHeight() - n4;
        int n6 = this.getWidth() - n3;
        graphics2.translate(n3, n4);
        n3 = 0;
        n4 = 0;
        int n7 = FitnessObjects.MENU_TEXT_FONT.getHeight();
        int n8 = 0;
        if (this.tileImage != null) {
            if (n7 < 20) {
                n7 = 20;
            }
            n8 = 22;
        }
        if ((n2 = n5 / ++n7) < (n = this.currentMenu.labels.length)) {
            int n9;
            graphics2.setColor(0x777777);
            graphics2.fillRect(n6 - 7 - 1, n4, 6, n5);
            graphics2.setColor(0);
            graphics2.drawRect(n6 - 7 - 2, n4, 7, n5);
            for (n9 = 1; n9 <= n; ++n9) {
                graphics2.drawLine(n6 - 7 - 2, n9 * n5 / n, n6 - 2, n9 * n5 / n);
            }
            graphics2.setColor(0xFF0000);
            n9 = this.currentMenu.selectedIndex;
            graphics2.fillRect(n6 - 7, n9 * n5 / n + 2, 4, n5 / n - 3);
            n6 = n6 - 7 - 6;
        }
        graphics2.setClip(0, 0, n6, n5);
        String[] stringArray = this.currentMenu.labels;
        graphics2.setColor(0);
        graphics2.setFont(FitnessObjects.MENU_TEXT_FONT);
        if (this.currentMenu.labels.length < n2) {
            n2 = this.currentMenu.labels.length;
        }
        if (this.startIndex == -1 && this.endIndex == -1) {
            this.startIndex = 0;
            this.endIndex = n2 - 1;
        }
        int n10 = this.currentMenu.selectedIndex;
        int n11 = 0;
        int n12 = this.startIndex;
        if (n10 == 0) {
            this.startIndex = 0;
            n12 = 0;
            this.endIndex = n2 - 1;
        } else if (n10 == n - 1) {
            n12 = this.startIndex = n10 - n2 + 1;
            this.endIndex = n10;
        } else if (n10 > this.endIndex) {
            n12 += n10 - this.endIndex;
            ++this.startIndex;
            ++this.endIndex;
        } else if (n10 < this.startIndex) {
            --n12;
            --this.startIndex;
            --this.endIndex;
        }
        int n13 = 2;
        while (n11 < n2) {
            int[] nArray;
            if (n12 + n11 == this.currentMenu.selectedIndex) {
                graphics2.setColor(0xFF0000);
                graphics2.drawRect(n3 + n8, n4, n6 - n8 - 1, 20);
                graphics2.setColor(0);
            }
            if ((nArray = this.currentMenu.tileIndexes) != null && this.tileImage != null) {
                graphics2.setClip(n3, n4, 20, 20);
                int n14 = nArray[n12 + n11] / this.tileColumns * 20;
                int n15 = nArray[n12 + n11] % this.tileColumns * 20;
                graphics2.drawImage(this.tileImage, n3 - n15, n4 - n14, 20);
                graphics2.setClip(0, 0, this.getWidth(), this.getHeight());
            }
            graphics2.drawString(stringArray[n12 + n11], n3 + n8 + 2, n4 + n13, 20);
            ++n11;
            n4 += n7;
        }
        if (!this.isDoubleBuffered()) {
            graphics.drawImage(this.bufferedImage, 0, 0, 20);
        }
    }

    private void resetMenu() {
        this.startIndex = -1;
        this.endIndex = -1;
        this.removeCommand(FitnessCommands.EXIT_COMMAND);
        this.removeCommand(FitnessCommands.BACK_COMMAND);
        if (this.currentMenu.parentMenuIndex == this.currentMenuIndex) {
            this.addCommand(FitnessCommands.EXIT_COMMAND);
        } else {
            this.addCommand(FitnessCommands.BACK_COMMAND);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.BACK_COMMAND) {
            this.doBack();
        } else if (command == FitnessCommands.SELECT_COMMAND) {
            this.doSelect();
        } else if (command == FitnessCommands.EXIT_COMMAND) {
            FitnessMIDlet.exit();
        }
        this.repaint();
    }

    private void doSelect() {
        int n = this.currentMenu.selectedIndex;
        int n2 = this.currentMenu.actionIDs[n];
        if (n2 < 0) {
            DisplayController.showForm(n2);
        } else {
            this.currentMenuIndex = n2;
            this.currentMenu = this.menus[this.currentMenuIndex];
            this.resetMenu();
        }
    }

    private void doBack() {
        this.currentMenuIndex = this.currentMenu.parentMenuIndex;
        this.currentMenu = this.menus[this.currentMenuIndex];
        this.resetMenu();
    }

    public void keyRepeated(int n) {
        this.processKeyAction(n);
    }

    public void keyPressed(int n) {
        this.processKeyAction(n);
    }

    public void keyReleased(int n) {
    }

    public void processKeyAction(int n) {
        int n2;
        if (this.inProcessKey) {
            return;
        }
        this.inProcessKey = true;
        boolean bl = false;
        if (n == 48) {
            this.currentMenu.selectedIndex = 9;
            bl = true;
        } else if (n >= 49 && n <= 57 && (n2 = n - 48 - 1) < this.currentMenu.labels.length) {
            this.currentMenu.selectedIndex = n2;
            bl = true;
        }
        if (bl) {
            this.repaint();
            try {
                this.doSelect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inProcessKey = false;
            return;
        }
        n2 = super.getGameAction(n);
        if (n2 == 6) {
            this.currentMenu.down();
        } else if (n2 == 1) {
            this.currentMenu.up();
        } else if (n2 == 2) {
            this.doBack();
        } else if (n2 == 8 || n2 == 5) {
            this.doSelect();
        }
        this.repaint();
        this.serviceRepaints();
        this.inProcessKey = false;
    }

    public void setCurrentMenuIndex(int n) {
        this.currentMenuIndex = n;
    }
}

