/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.progress;

import com.ascendo.fitness.database.nutrition.NutritionDailyDatabase;
import com.ascendo.fitness.database.nutrition.NutritionDailyRecord;
import com.ascendo.fitness.database.nutrition.NutritionMasterDatabase;
import com.ascendo.fitness.database.nutrition.NutritionMasterRecord;
import com.ascendo.fitness.database.others.UserGoalsRecord;
import com.ascendo.fitness.forms.progress.GraphForm;
import com.ascendo.fitness.util.DateUtils;
import javax.microedition.lcdui.Graphics;

public final class CaloriesIntakeGraph
extends GraphForm {
    public CaloriesIntakeGraph() {
        super(1);
    }

    public void paintGraph(Graphics graphics) {
        int n = 0;
        int n2 = this.refX - this.barWidth;
        graphics.setColor(255);
        for (int i = 0; i < 7; ++i) {
            n2 += this.barWidth;
            if (this.readings[i] <= 0) continue;
            n = this.yStart - (this.readings[i] - this.startValue) * 100 / this.valuePerPixel;
            graphics.fillRect(n2 - this.barWidth / 2 + 5, n, this.barWidth - 10, this.yStart - n);
        }
    }

    public int getReferenceValue() {
        return UserGoalsRecord.caloriesIntake;
    }

    public boolean calculateReadings(long l, long l2) {
        NutritionDailyDatabase nutritionDailyDatabase = NutritionDailyDatabase.getInstance();
        nutritionDailyDatabase.enumerate(l, l2, true);
        if (nutritionDailyDatabase.found <= 0) {
            return false;
        }
        for (int i = 0; i < this.readings.length; ++i) {
            String string = DateUtils.longToDateString(l + (long)i * 86400000L, false);
            this.readings[i] = 0;
            if (nutritionDailyDatabase.found <= 0) continue;
            int n = nutritionDailyDatabase.displayNames.size();
            for (int j = 0; j < n; ++j) {
                if (!nutritionDailyDatabase.displayName(j).equals(string)) continue;
                int n2 = nutritionDailyDatabase.recordID(j);
                nutritionDailyDatabase.fetch(n2);
                NutritionMasterDatabase.getInstance().fetch(NutritionDailyRecord.referenceRecordID);
                int n3 = i;
                this.readings[n3] = this.readings[n3] + NutritionDailyRecord.quantity * NutritionMasterRecord.caloriesPerServing / 10;
            }
        }
        return true;
    }
}

