/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.nutrition;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessMIDlet;
import com.ascendo.fitness.custom.YesNoAlert;
import com.ascendo.fitness.database.nutrition.NutritionMasterDatabase;
import com.ascendo.fitness.database.nutrition.NutritionMasterRecord;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.forms.nutrition.NutritionEntryForm;
import com.ascendo.fitness.forms.nutrition.NutritionSearchForm;
import com.ascendo.fitness.util.ConversionUtils;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class NutritionTypeForm
extends Form
implements CommandListener {
    private Item descriptionField;
    private Item servingTypeField;
    private Item proteinsField;
    private Item fatsField;
    private Item carbohydratesField;
    private Item gramsPerServingField;
    private Item caloriesPerServingField;
    private boolean gotoEntryForm;
    private int mode;
    private int preset = 0;
    private int elementNum;

    public NutritionTypeForm(String string) {
        this(string, false);
    }

    public NutritionTypeForm(String string, boolean bl) {
        super("");
        this.gotoEntryForm = bl;
        NutritionMasterRecord.set(-1, string, FitnessMIDlet.SERVING_TYPES[0], 1, 50, 10, 10, 10);
        this.init(false);
    }

    public NutritionTypeForm(boolean bl) {
        super("");
        this.init(bl);
    }

    private void init(boolean bl) {
        if (bl) {
            this.setTitle("Display");
            this.mode = 20;
        } else if (NutritionMasterRecord.recordID == -1) {
            this.setTitle("New Type");
            this.mode = 40;
        } else {
            this.setTitle("Edit Type");
            this.mode = 30;
        }
        if (bl) {
            this.descriptionField = new StringItem("Description: ", NutritionMasterRecord.description);
            this.servingTypeField = new StringItem("Servings: ", NutritionMasterRecord.servings);
            this.gramsPerServingField = new StringItem("Grams/Serving: ", "" + NutritionMasterRecord.gramsPerServing);
            this.proteinsField = new StringItem("Proteins: ", "" + NutritionMasterRecord.proteins / 10 + "." + NutritionMasterRecord.proteins % 10);
            this.carbohydratesField = new StringItem("Carbohydrates: ", "" + NutritionMasterRecord.carbohydrates / 10 + "." + NutritionMasterRecord.carbohydrates % 10);
            this.fatsField = new StringItem("Fats: ", "" + NutritionMasterRecord.fats / 10 + "." + NutritionMasterRecord.fats / 10);
            this.caloriesPerServingField = new StringItem("Cals/Serving: ", "" + NutritionMasterRecord.caloriesPerServing);
        } else {
            this.descriptionField = new TextField("Description: ", NutritionMasterRecord.description, 30, 0);
            System.out.println("Rohit 5");
            this.proteinsField = new TextField("Proteins: ", NutritionMasterRecord.proteins / 10 + "." + NutritionMasterRecord.proteins % 10, 3, 5);
            System.out.println("Rohit 6");
            this.carbohydratesField = new TextField("Carbohydrates: ", NutritionMasterRecord.carbohydrates / 10 + "." + NutritionMasterRecord.carbohydrates % 10, 3, 5);
            System.out.println("Rohit 7");
            this.fatsField = new TextField("Fats: ", NutritionMasterRecord.fats / 10 + "." + NutritionMasterRecord.fats % 10, 3, 5);
            System.out.println("Rohit 8");
            this.caloriesPerServingField = new TextField("Cals/Serving: ", Integer.toString(NutritionMasterRecord.caloriesPerServing), 5, 2);
            System.out.println("Rohit 9");
            this.servingTypeField = new ChoiceGroup("Servings: ", 4, FitnessMIDlet.SERVING_TYPES, null);
            System.out.println("Preset from db = " + NutritionMasterRecord.servings.toLowerCase());
            for (int i = 0; i < FitnessMIDlet.SERVING_TYPES.length; ++i) {
                if (!FitnessMIDlet.SERVING_TYPES[i].toLowerCase().equals(NutritionMasterRecord.servings.toLowerCase())) continue;
                this.preset = i;
            }
            ((ChoiceGroup)this.servingTypeField).setSelectedIndex(this.preset, true);
            this.gramsPerServingField = new TextField("Grams/Serving: ", Integer.toString(NutritionMasterRecord.gramsPerServing), 5, 2);
        }
        this.append(this.descriptionField);
        this.append(this.servingTypeField);
        this.append(this.gramsPerServingField);
        this.append(this.caloriesPerServingField);
        this.append(this.carbohydratesField);
        this.append(this.fatsField);
        this.append(this.proteinsField);
        this.addCommand(FitnessCommands.CANCEL_COMMAND);
        if (bl) {
            this.addCommand(FitnessCommands.ADD_NUTRITION_COMMAND);
        } else {
            this.addCommand(FitnessCommands.SAVE_COMMAND);
        }
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == DisplayController.MESSAGE_ALERT && command == Alert.DISMISS_COMMAND) {
            DisplayController.showMenu(1);
            return;
        }
        if (command == FitnessCommands.CANCEL_COMMAND) {
            if (this.mode != 40) {
                DisplayController.show((Displayable)new NutritionSearchForm(this.mode));
            } else {
                DisplayController.showMenu(1);
            }
        } else if (command == FitnessCommands.SAVE_COMMAND) {
            this.doSubmit(false);
        } else if (command == FitnessCommands.YES_COMMAND) {
            this.doSubmit(true);
        } else if (command == FitnessCommands.NO_COMMAND) {
            DisplayController.show((Displayable)this);
        } else {
            this.doAddNutrition();
        }
    }

    private void doAddNutrition() {
        DisplayController.show((Displayable)new NutritionEntryForm(40));
    }

    private void doSubmit(boolean bl) {
        Object object;
        String string = ConversionUtils.getInvalidField(this);
        if (string != null) {
            System.out.println("invalid fields =" + string);
            DisplayController.error(this.getTitle(), "Invalid (or No) value specified for " + string.substring(0, string.indexOf(58)));
            System.out.println("should return");
            return;
        }
        NutritionMasterDatabase nutritionMasterDatabase = NutritionMasterDatabase.getInstance();
        if (!bl) {
            NutritionMasterRecord.recordID = -1;
            this.elementNum = ((ChoiceGroup)this.servingTypeField).getSelectedIndex();
            object = ((TextField)this.descriptionField).getString();
            nutritionMasterDatabase.search(((String)object).getBytes(), false);
            if (nutritionMasterDatabase.found > 0) {
                NutritionMasterRecord.recordID = nutritionMasterDatabase.recordID(0);
                YesNoAlert yesNoAlert = new YesNoAlert("Nutrition Type", "Entry \"" + (String)object + "\" already exists. Over write?", this);
                DisplayController.show((Displayable)yesNoAlert);
                return;
            }
        }
        try {
            System.out.println("choice group value retreived elementNum=" + this.elementNum + " and preset - " + this.preset);
            if (this.elementNum == -1) {
                System.out.println("Element selected = -1");
                this.elementNum = this.preset;
            }
            NutritionMasterRecord.description = ((TextField)this.descriptionField).getString();
            NutritionMasterRecord.servings = ((ChoiceGroup)this.servingTypeField).getString(this.elementNum);
            NutritionMasterRecord.gramsPerServing = Integer.parseInt(((TextField)this.gramsPerServingField).getString());
            NutritionMasterRecord.proteins = Integer.parseInt(this.getDecimalValue(((TextField)this.proteinsField).getString()));
            NutritionMasterRecord.carbohydrates = Integer.parseInt(this.getDecimalValue(((TextField)this.carbohydratesField).getString()));
            NutritionMasterRecord.fats = Integer.parseInt(this.getDecimalValue(((TextField)this.fatsField).getString()));
            NutritionMasterRecord.caloriesPerServing = Integer.parseInt(((TextField)this.caloriesPerServingField).getString());
            object = (NutritionMasterRecord.description + '|' + NutritionMasterRecord.servings + '|' + NutritionMasterRecord.gramsPerServing + '|' + NutritionMasterRecord.caloriesPerServing + '|' + NutritionMasterRecord.carbohydrates + '|' + NutritionMasterRecord.proteins + '|' + NutritionMasterRecord.fats).getBytes();
            if (NutritionMasterRecord.recordID == -1) {
                NutritionMasterRecord.recordID = NutritionMasterDatabase.getInstance().addRecord((byte[])object);
            } else {
                nutritionMasterDatabase.editRecord(NutritionMasterRecord.recordID, (byte[])object);
            }
            if (this.gotoEntryForm) {
                this.deleteAll();
                DisplayController.show((Displayable)new NutritionEntryForm(50));
            } else {
                this.deleteAll();
                if (DefaultsRecord.userOption == 0) {
                    DisplayController.message("Ascendo Fitness v2.3", this.mode == 40 ? "You have added a new Type to the Nutrition database. Select Nutrition, Edit Type to modify." : "You have edited a Nutrition Type.", this);
                } else {
                    DisplayController.showMenu(1);
                }
            }
        }
        catch (Exception exception) {
            DisplayController.show((Displayable)new Alert("New Type", "Error while updating database.\nMessage: " + exception.toString(), null, AlertType.ERROR));
        }
    }

    private String getDecimalValue(String string) {
        int n = 0;
        String string2 = "";
        String string3 = "";
        try {
            n = string.indexOf(46);
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, n + 2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return string + "0";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3 + string2;
    }
}

