/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.util.StringVector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public abstract class EditHelper
implements CommandListener {
    protected final String formTitle;
    protected final int backMenu;
    protected List itemsList;

    public EditHelper(String string, int n) {
        this.formTitle = string;
        this.backMenu = n;
    }

    public final void doIt() {
        StringVector stringVector = this.enumerate();
        if (stringVector == null || stringVector.size() <= 0) {
            DisplayController.show((Displayable)new Alert(this.formTitle, "No entries found", null, AlertType.INFO));
            return;
        }
        String[] stringArray = new String[stringVector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringVector.elementAt(i);
        }
        this.itemsList = new List(this.formTitle, 3, stringArray, null);
        this.itemsList.addCommand(FitnessCommands.BACK_COMMAND);
        this.itemsList.addCommand(FitnessCommands.DELETE_COMMAND);
        this.itemsList.setCommandListener((CommandListener)this);
        DisplayController.show((Displayable)this.itemsList);
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.SELECT_COMMAND || command == List.SELECT_COMMAND) {
            this.doSelect(this.itemsList.getSelectedIndex());
        } else if (command == FitnessCommands.DELETE_COMMAND) {
            this.doDelete(this.itemsList.getSelectedIndex());
        } else if (command == FitnessCommands.BACK_COMMAND) {
            DisplayController.showMenu(this.backMenu);
        }
    }

    protected abstract StringVector enumerate();

    protected abstract void doDelete(int var1);

    protected abstract void doSelect(int var1);
}

