/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.custom.YesNoAlert;
import com.ascendo.fitness.database.DailyDatabase;
import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;

public class DeleteHelper
extends Form
implements CommandListener {
    private final DateField dateField;
    private DailyDatabase dailyDatabase;
    private int backMenu;

    public DeleteHelper(DailyDatabase dailyDatabase, String string, int n) {
        super(string);
        this.dailyDatabase = dailyDatabase;
        this.backMenu = n;
        this.dateField = new DateField("Date: ", 1);
        this.dateField.setDate(new Date());
        this.append((Item)this.dateField);
        this.addCommand(FitnessCommands.SUBMIT_COMMAND);
        this.addCommand(FitnessCommands.BACK_COMMAND);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.SUBMIT_COMMAND) {
            this.doSubmit();
        } else if (command == FitnessCommands.YES_COMMAND) {
            this.go();
            DisplayController.showMenu(this.backMenu);
        } else if (command == FitnessCommands.BACK_COMMAND) {
            DisplayController.showMenu(this.backMenu);
        } else {
            DisplayController.show((Displayable)this);
        }
    }

    private void doSubmit() {
        this.dailyDatabase.enumerate(0L, this.dateField.getDate().getTime(), true);
        if (this.dailyDatabase.found <= 0) {
            DisplayController.error("Delete By Date", "No records found.");
            return;
        }
        DisplayController.show((Displayable)new YesNoAlert("Delete By Date", "" + this.dailyDatabase.found + " record(s) found. Are you sure to delete?", this));
    }

    private void go() {
        int n = this.dailyDatabase.recordIDs.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.dailyDatabase.deleteRecord(this.dailyDatabase.recordID(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

