/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.progress;

import com.ascendo.fitness.database.activity.ActivityDailyDatabase;
import com.ascendo.fitness.database.activity.ActivityDailyRecord;
import com.ascendo.fitness.database.activity.ActivityMasterDatabase;
import com.ascendo.fitness.database.activity.ActivityMasterRecord;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserGoalsRecord;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import com.ascendo.fitness.forms.progress.GraphForm;
import com.ascendo.fitness.util.DateUtils;
import javax.microedition.lcdui.Graphics;

public final class CaloriesBurnedGraph
extends GraphForm {
    public CaloriesBurnedGraph() {
        super(2);
    }

    public void paintGraph(Graphics graphics) {
        int n = 0;
        int n2 = this.refX - this.barWidth;
        graphics.setColor(255);
        for (int i = 0; i < 7; ++i) {
            n2 += this.barWidth;
            if (this.readings[i] <= 0) continue;
            n = this.yStart - (this.readings[i] - this.startValue) * 100 / this.valuePerPixel;
            graphics.fillRect(n2 - this.barWidth / 2 + 5, n, this.barWidth - 10, this.yStart - n);
        }
    }

    public int getReferenceValue() {
        return UserGoalsRecord.caloriesBurned;
    }

    public boolean calculateReadings(long l, long l2) {
        ActivityDailyDatabase activityDailyDatabase = ActivityDailyDatabase.getInstance();
        activityDailyDatabase.enumerate(l, l2, true);
        if (activityDailyDatabase.found <= 0) {
            return false;
        }
        for (int i = 0; i < this.readings.length; ++i) {
            String string = DateUtils.longToDateString(l + (long)i * 86400000L, false);
            this.readings[i] = 0;
            if (activityDailyDatabase.found <= 0) continue;
            int n = DefaultsRecord.measurement == 0 ? UserSettingsRecord.weightUS : UserSettingsRecord.weightMetric;
            int n2 = activityDailyDatabase.displayNames.size();
            for (int j = 0; j < n2; ++j) {
                if (!activityDailyDatabase.displayName(j).equals(string)) continue;
                int n3 = activityDailyDatabase.recordID(j);
                activityDailyDatabase.fetch(n3);
                ActivityMasterDatabase.getInstance().fetch(ActivityDailyRecord.referenceRecordID);
                int n4 = DefaultsRecord.measurement == 0 ? ActivityMasterRecord.caloriesPerLBs : ActivityMasterRecord.caloriesPerKGs;
                int n5 = n / 10;
                int n6 = n % 10;
                int n7 = n5 * n4 + n6 * n4 / 10;
                n7 = ActivityDailyRecord.quantity * n7;
                int n8 = i;
                this.readings[n8] = this.readings[n8] + n7;
            }
        }
        return true;
    }
}

