/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.assistants;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class HeartRateForm
extends Form
implements CommandListener,
ItemStateListener {
    private final TextField ageField = new TextField("Age: ", "1", 5, 2);
    private final StringItem mhr = new StringItem("Maximum Heart Rate: ", "");

    public HeartRateForm() {
        super("Heart Rate");
        this.ageField.setString("" + UserSettingsRecord.age);
        this.mhr.setText("" + (208 - UserSettingsRecord.age * 7 / 10));
        this.append((Item)this.ageField);
        this.append((Item)this.mhr);
        this.addCommand(FitnessCommands.BACK_COMMAND);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.BACK_COMMAND) {
            DisplayController.showMenu(7);
        }
    }

    public void itemStateChanged(Item item) {
        this.calculateHeartRate();
    }

    private void calculateHeartRate() {
        try {
            int n = Integer.parseInt(this.ageField.getString());
            if (n < 0) {
                throw new Exception();
            }
            this.mhr.setText("" + (208 - n * 7 / 10));
        }
        catch (Exception exception) {
            this.mhr.setText("Invalid input(s).");
        }
    }
}

