/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.activity;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.custom.YesNoAlert;
import com.ascendo.fitness.database.MasterDatabase;
import com.ascendo.fitness.database.activity.ActivityMasterDatabase;
import com.ascendo.fitness.forms.SearchForm;
import com.ascendo.fitness.forms.activity.ActivityEntryForm;
import com.ascendo.fitness.forms.activity.ActivityTypeForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public final class ActivitySearchForm
extends SearchForm {
    public ActivitySearchForm(int n) {
        super(n, 2);
        if (n == 10) {
            this.setTitle("New Entry");
        } else if (n == 30) {
            this.setTitle("Edit Type");
        } else {
            this.setTitle("Browse");
        }
    }

    protected void doSearch() {
        ActivityMasterDatabase activityMasterDatabase = ActivityMasterDatabase.getInstance();
        byte[] byArray = this.itemField.getString().getBytes();
        try {
            activityMasterDatabase.search(byArray, this.mode == 20 || this.mode == 30);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (activityMasterDatabase.found <= 0) {
            if (this.mode == 20) {
                DisplayController.show((Displayable)new Alert(this.getTitle(), "No entries found", null, AlertType.INFO));
                return;
            }
            DisplayController.show((Displayable)new YesNoAlert("Ascendo Fitness v2.3", "Item \"" + this.itemField.getString() + "\" not found. Do you want to add it to Nutrition database?", this));
        } else {
            if (this.matchingItemsList == null) {
                this.matchingItemsList = new List("", 3);
                if (this.mode == 10) {
                    this.matchingItemsList.setTitle("New Entry");
                } else if (this.mode == 30) {
                    this.matchingItemsList.setTitle("Edit Type");
                } else {
                    this.matchingItemsList.setTitle("Browse");
                }
                this.matchingItemsList.addCommand(FitnessCommands.SELECT_COMMAND);
                this.matchingItemsList.addCommand(FitnessCommands.BACK_COMMAND);
                if (this.mode == 30) {
                    this.matchingItemsList.addCommand(FitnessCommands.DELETE_COMMAND);
                }
                this.matchingItemsList.setCommandListener((CommandListener)this);
            } else if (this.matchingItemsList.size() > 0) {
                this.matchingItemsList.deleteAll();
            }
            int n = activityMasterDatabase.displayNames.size();
            int n2 = -1;
            String string = null;
            for (int i = 0; i < n; ++i) {
                string = activityMasterDatabase.displayName(i);
                if (this.mode == 20 && n2 == -1 && MasterDatabase.compareBytes(string.getBytes(), byArray) == 0) {
                    n2 = i;
                }
                this.matchingItemsList.append(string, null);
            }
            if (this.mode == 20) {
                if (n2 == -1) {
                    n2 = 0;
                }
                try {
                    this.matchingItemsList.setSelectedIndex(n2 + 7, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.matchingItemsList.setSelectedIndex(n2, true);
            }
            DisplayController.show((Displayable)this.matchingItemsList);
            byArray = null;
        }
    }

    public void doItemSelection(int n) {
        if (this.matchingItemsList != null) {
            this.matchingItemsList.deleteAll();
        }
        ActivityMasterDatabase activityMasterDatabase = ActivityMasterDatabase.getInstance();
        activityMasterDatabase.fetch(activityMasterDatabase.recordID(n));
        if (this.mode == 10) {
            DisplayController.show((Displayable)new ActivityEntryForm(40));
        } else if (this.mode == 30) {
            DisplayController.show((Displayable)new ActivityTypeForm(false));
        } else {
            DisplayController.show((Displayable)new ActivityTypeForm(true));
        }
    }

    public void doDelete(int n) {
        ActivityMasterDatabase activityMasterDatabase = ActivityMasterDatabase.getInstance();
        int n2 = activityMasterDatabase.recordID(n);
        try {
            activityMasterDatabase.deleteRecord(n2);
            this.matchingItemsList.delete(n);
            activityMasterDatabase.recordIDs.removeIntAt(n);
            activityMasterDatabase.displayNames.removeElementAt(n);
            if (this.matchingItemsList.size() <= 0) {
                DisplayController.showMenu(this.backMenu);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void yes() {
        DisplayController.show((Displayable)new ActivityTypeForm(this.itemField.getString(), true));
    }

    public void no() {
        DisplayController.show((Displayable)this);
    }
}

