/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.progress;

import com.ascendo.fitness.database.journal.JournalDatabase;
import com.ascendo.fitness.database.journal.JournalRecord;
import com.ascendo.fitness.database.others.UserGoalsRecord;
import com.ascendo.fitness.forms.progress.GraphForm;
import com.ascendo.fitness.util.DateUtils;
import javax.microedition.lcdui.Graphics;

public final class WeightGraph
extends GraphForm {
    public WeightGraph() {
        super(0);
    }

    public void paintGraph(Graphics graphics) {
        int n = 0;
        int n2 = this.refX - this.barWidth;
        int n3 = -1;
        int n4 = -1;
        graphics.setColor(255);
        graphics.drawString(this.usUnits ? "lbs" : "KGs", 38, 10, 20);
        for (int i = 0; i < 7; ++i) {
            n2 += this.barWidth;
            if (this.readings[i] <= 0) continue;
            n = this.yStart - (this.readings[i] - this.startValue) * 100 / this.valuePerPixel;
            if (n3 != -1 && n4 != -1) {
                graphics.drawLine(n3, n4, n2, n);
                n3 = -1;
                n4 = -1;
            }
            graphics.fillRect(n2 - 2, n - 2, 4, 4);
            n3 = n2;
            n4 = n;
        }
    }

    public int getReferenceValue() {
        return this.usUnits ? UserGoalsRecord.weightUS : UserGoalsRecord.weightMetric;
    }

    public boolean calculateReadings(long l, long l2) {
        JournalDatabase journalDatabase = JournalDatabase.getInstance();
        journalDatabase.enumerate(l, l2, true);
        if (journalDatabase.found <= 0) {
            return false;
        }
        for (int i = 0; i < this.readings.length; ++i) {
            String string = DateUtils.longToDateString(l + (long)i * 86400000L, false);
            this.readings[i] = 0;
            int n = 0;
            if (journalDatabase.found <= 0) continue;
            int n2 = journalDatabase.displayNames.size();
            for (int j = 0; j < n2; ++j) {
                if (!journalDatabase.displayName(j).equals(string)) continue;
                int n3 = journalDatabase.recordID(j);
                journalDatabase.fetch(n3);
                int n4 = i;
                this.readings[n4] = this.readings[n4] + (this.usUnits ? JournalRecord.weightUS : JournalRecord.weightMetric);
                ++n;
            }
            if (n <= 0) continue;
            int n5 = i;
            this.readings[n5] = this.readings[n5] / n;
        }
        return true;
    }
}

