/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.progress;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.util.DateUtils;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GraphForm
extends Canvas
implements CommandListener {
    protected int week = 0;
    private int graphType;
    protected final int[] readings = new int[7];
    protected final int barWidth;
    protected Graphics bufferedGraphics;
    protected Image bufferedImage;
    protected Image bgImage;
    private int refValue;
    private int min;
    private int max;
    private boolean dataFound;
    private String dateStr1;
    private String dateStr2;
    protected boolean usUnits = DefaultsRecord.measurement == 0;
    protected int yStart;
    protected int leftoverHeight;
    protected int leftoverWidth;
    protected int valuePerPixel;
    protected int valuePerTenPixels;
    protected int displacement;
    protected int startValue;
    protected int refX;
    private boolean reCalculate = true;

    public GraphForm(int n) {
        this.setTitle(FitnessObjects.GRAPH_TITLES[n]);
        this.graphType = n;
        this.barWidth = (this.getWidth() - 33) / 7;
        if (!this.isDoubleBuffered()) {
            this.bufferedImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.bufferedGraphics = this.bufferedImage.getGraphics();
        }
        try {
            this.bgImage = Image.createImage((String)"/images/Background.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addCommand(FitnessCommands.BACK_COMMAND);
        this.addCommand(FitnessCommands.HELP_COMMAND);
        this.setCommandListener(this);
        this.refValue = this.getReferenceValue();
        this.enumerateValues();
    }

    public final void paint(Graphics graphics) {
        int n;
        if (this.reCalculate) {
            this.yStart = this.getHeight() - 20;
            this.leftoverHeight = this.yStart - this.yStart % 10;
            this.leftoverWidth = this.getWidth() - 33;
            this.refX = 33 + this.barWidth / 2;
            this.displacement = 0;
            this.displacement = this.max - this.min;
            this.valuePerPixel = this.displacement * 100 / this.leftoverHeight;
            this.valuePerTenPixels = this.valuePerPixel * 10 / 100;
            if (this.valuePerPixel * 10 % 100 > 50) {
                ++this.valuePerTenPixels;
            }
            if (this.valuePerTenPixels == 0) {
                this.valuePerTenPixels = 1;
            }
            this.valuePerPixel = this.valuePerTenPixels * 10;
            this.startValue = this.min;
            this.reCalculate = false;
        }
        Graphics graphics2 = graphics;
        if (!this.isDoubleBuffered()) {
            graphics2 = this.bufferedGraphics;
        }
        graphics2.setColor(0xFFFFFF);
        graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.bgImage != null) {
            graphics2.drawImage(this.bgImage, 0, -20, 20);
        }
        graphics2.setColor(0);
        graphics2.drawRect(33, 0, this.getWidth() - 33, this.yStart);
        graphics2.setColor(0);
        Font font = Font.getFont((int)0, (int)0, (int)8);
        graphics2.setFont(font);
        graphics2.drawString(this.dateStr1, 38, n + 2, 20);
        graphics2.drawString(this.dateStr2, this.getWidth() - font.stringWidth(this.dateStr2), n + 2, 20);
        graphics2.setFont(Font.getDefaultFont());
        if (!this.dataFound) {
            graphics2.setColor(0xFF0000);
            graphics2.drawString("No Data Found", 38, n - 5, 36);
        } else {
            graphics2.setColor(0);
            int n2 = this.startValue + this.valuePerTenPixels;
            boolean bl = true;
            for (n = this.yStart; n > 0; n -= 20) {
                graphics2.setColor(0);
                graphics2.drawString(Integer.toString(n2), 31, n - 2, 40);
                graphics2.setColor(0xDDDDDD);
                if (!bl) {
                    graphics2.drawLine(34, n, this.getWidth(), n);
                }
                bl = false;
                graphics2.drawLine(31, n - 10, this.getWidth(), n - 10);
                n2 += this.valuePerTenPixels * 2;
            }
            if (this.graphType == 0) {
                this.drawReferenceLine(graphics2);
                this.paintGraph(graphics2);
            } else {
                this.paintGraph(graphics2);
                this.drawReferenceLine(graphics2);
            }
        }
        if (!this.isDoubleBuffered()) {
            graphics.drawImage(this.bufferedImage, 0, 0, 20);
        }
    }

    private void drawReferenceLine(Graphics graphics) {
        int n = this.yStart - (this.refValue - this.startValue) * 100 / this.valuePerPixel;
        int n2 = this.refX;
        int n3 = 0;
        int n4 = 0;
        graphics.setColor(0xFF0000);
        for (int i = 0; i < 7; ++i) {
            if (i > 0) {
                graphics.drawLine(n3, n4, n2, n);
            }
            graphics.fillRect(n2 - 3, n - 3, 6, 6);
            n3 = n2;
            n4 = n;
            n2 += this.barWidth;
        }
    }

    public abstract void paintGraph(Graphics var1);

    public abstract int getReferenceValue();

    public abstract boolean calculateReadings(long var1, long var3);

    public void enumerateValues() {
        long l = DateUtils.getWeekStart(this.week);
        long l2 = l + 604800000L - 1001L;
        this.dateStr1 = DateUtils.longToDateString(l, false);
        this.dateStr2 = DateUtils.longToDateString(l2, false);
        this.dataFound = this.calculateReadings(l, l2);
        if (this.dataFound) {
            this.findMinMax();
        }
    }

    private void findMinMax() {
        int n;
        this.min = Integer.MAX_VALUE;
        this.max = 0;
        for (n = 0; n < 7; ++n) {
            if (this.readings[n] <= 0) continue;
            if (this.min > this.readings[n]) {
                this.min = this.readings[n];
            }
            if (this.max >= this.readings[n]) continue;
            this.max = this.readings[n];
        }
        if (this.refValue < this.min) {
            this.min = this.refValue;
        }
        if (this.refValue > this.max) {
            this.max = this.refValue;
        }
        System.out.println("Min and maximum graph values after ref comparison= " + this.min + "," + this.max);
        n = 0;
        n = this.min > 20 ? this.min / 20 : (this.max > 20 ? this.max / 20 : 1);
        this.min -= this.max / 20;
        if (this.min < 0) {
            this.min = 0;
        }
        this.max += this.max / 20;
        System.out.println("Min and maximum graph values after 10% sub= " + this.min + "," + this.max);
        this.reCalculate = true;
    }

    public final void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            ++this.week;
        } else if (this.getGameAction(n) == 5) {
            --this.week;
        }
        this.enumerateValues();
        this.repaint();
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command.equals(FitnessCommands.BACK_COMMAND)) {
            DisplayController.showMenu(4);
        } else if (command.equals(FitnessCommands.HELP_COMMAND)) {
            DisplayController.show((Displayable)new Alert("Ascendo Fitness v2.3", "Move graph forward or backward by 1 week using the arrow keys and/or the 4 and 6 key on the numeric keypad, depending on your device.", null, AlertType.INFO));
        }
    }
}

