/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.assistants;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import com.ascendo.fitness.util.ConversionUtils;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class HealthyAndIdealWeightForm
extends Form
implements CommandListener,
ItemStateListener {
    public static final int TYPE_HEALTHY = 10;
    public static final int TYPE_IDEAL = 20;
    private final TextField height1Field;
    private final TextField height2Field;
    private ChoiceGroup genderField;
    private final StringItem idealWeight;
    private StringItem weightHigh;
    private final int type;

    public HealthyAndIdealWeightForm(int n) {
        super(n == 20 ? "Ideal Weight" : "Healthy Weight");
        this.type = n;
        this.height1Field = new TextField("Height (" + FitnessObjects.HEIGHT1_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
        this.height2Field = new TextField("Height (" + FitnessObjects.HEIGHT2_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
        if (n == 20) {
            this.genderField = new ChoiceGroup("Gender: ", 4, FitnessObjects.GENDER_TYPES, null);
        }
        this.idealWeight = new StringItem((n == 20 ? "Ideal Weight" : "Weight Low") + " (" + FitnessObjects.WEIGHT_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "");
        if (n == 10) {
            this.weightHigh = new StringItem("Weight High (" + FitnessObjects.WEIGHT_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "");
        }
        boolean bl = DefaultsRecord.measurement == 0;
        this.height1Field.setString("" + (bl ? UserSettingsRecord.height1US : UserSettingsRecord.height1Metric));
        this.height2Field.setString("" + (bl ? UserSettingsRecord.height2US : UserSettingsRecord.height2Metric));
        if (n == 20) {
            this.genderField.setSelectedIndex(UserSettingsRecord.genderIndex, true);
        }
        if (n == 20) {
            this.calculateIdealWeight();
        } else {
            this.calculateHealthyWeight();
        }
        this.append((Item)this.height1Field);
        this.append((Item)this.height2Field);
        if (n == 20) {
            this.append((Item)this.genderField);
        }
        this.append((Item)this.idealWeight);
        if (n == 10) {
            this.append((Item)this.weightHigh);
        }
        this.addCommand(FitnessCommands.BACK_COMMAND);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    private void calculateHealthyWeight() {
        boolean bl = DefaultsRecord.measurement == 0;
        try {
            int n = Integer.parseInt(this.height1Field.getString());
            int n2 = Integer.parseInt(this.height2Field.getString());
            if (n < 0 || n2 < 0) {
                throw new Exception();
            }
            int n3 = 0;
            n3 = bl ? ConversionUtils.toMeters(n, n2) * 100 + ConversionUtils.toCentimeters(n, n2) : n * 100 + n2;
            int n4 = 185 * n3 * n3 / 10;
            int n5 = 25 * n3 * n3;
            n4 /= 10000;
            n5 /= 10000;
            if (bl) {
                n4 = ConversionUtils.toLbs(n4);
                n5 = ConversionUtils.toLbs(n5);
            }
            this.idealWeight.setText(Integer.toString(n4));
            this.weightHigh.setText(Integer.toString(n5));
        }
        catch (Exception exception) {
            this.idealWeight.setText("Invalid input(s).");
            this.weightHigh.setText("Invalid input(s).");
        }
    }

    private void calculateIdealWeight() {
        boolean bl = DefaultsRecord.measurement == 0;
        int n = 0;
        try {
            int n2 = Integer.parseInt(this.height1Field.getString());
            int n3 = Integer.parseInt(this.height2Field.getString());
            if (n2 < 0 || n3 < 0) {
                throw new Exception();
            }
            int n4 = this.genderField.getSelectedIndex();
            n = bl ? (n4 == 0 ? 110 + 5 * (n2 * 12 + n3 - 60) : 108 + 375 * (n2 * 12 + n3 - 60) / 100) : (n4 == 0 ? 50 + 23 * ((n2 * 100 + n3 - 152) * 100 / 254) / 10 : 49 + 17 * ((n2 * 100 + n3 - 152) * 100 / 254) / 10);
            this.idealWeight.setText(Integer.toString(n));
        }
        catch (Exception exception) {
            this.idealWeight.setText("Invalid input(s).");
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.BACK_COMMAND) {
            DisplayController.showMenu(7);
        }
    }

    public void itemStateChanged(Item item) {
        if (this.type == 10) {
            this.calculateHealthyWeight();
        } else {
            this.calculateIdealWeight();
        }
    }
}

