/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.database;

import com.ascendo.fitness.database.MicroDatabase;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.util.DateUtils;
import com.ascendo.fitness.util.Tokenizer;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;

public abstract class DailyDatabase
extends MicroDatabase {
    private final boolean include3rdField;

    protected DailyDatabase(String string, boolean bl) {
        super(string);
        this.include3rdField = bl;
    }

    public final void enumerate(final long l, final long l2, boolean bl) {
        this.found = 0;
        try {
            int n;
            RecordEnumeration recordEnumeration = this.recordStore.enumerateRecords(new RecordFilter(){

                public boolean matches(byte[] byArray) {
                    long l3;
                    if (byArray == null || byArray.length <= 0) {
                        return false;
                    }
                    boolean bl = false;
                    bl = l < 0L || l2 < 0L ? true : (l3 = DailyDatabase.this.getLong(byArray)) >= l && l3 <= l2;
                    return bl;
                }
            }, null, false);
            if (recordEnumeration.numRecords() <= 0) {
                return;
            }
            this.found = recordEnumeration.numRecords();
            this.recordIDs.clear();
            this.displayNames.clear();
            for (n = 0; n < this.found; ++n) {
                this.recordIDs.addElement(recordEnumeration.nextRecordId());
            }
            n = this.found;
            Tokenizer tokenizer = new Tokenizer('|');
            for (int i = 0; i < n; ++i) {
                try {
                    tokenizer.setLine(this.recordStore.getRecord(this.recordID(i)));
                    long l3 = Long.parseLong(tokenizer.nextString());
                    if (!bl) {
                        String string = DateUtils.longToDateString(l3, true) + ": " + " ";
                        if (!this.include3rdField) {
                            string = string + tokenizer.nextString();
                        } else {
                            String string2 = tokenizer.nextString();
                            String string3 = tokenizer.nextString();
                            string = string + (DefaultsRecord.measurement == 0 ? string2 : string3);
                            string = string + " " + tokenizer.nextString();
                        }
                        this.displayNames.addElement(string);
                        continue;
                    }
                    this.displayNames.addElement(DateUtils.longToDateString(l3, false));
                    continue;
                }
                catch (Exception exception) {
                    --this.found;
                }
            }
            int[] nArray = this.recordIDs.toArray();
            String[] stringArray = this.displayNames.toArray();
            this.quickSort(nArray, stringArray, 0, stringArray.length - 1, bl);
            this.recordIDs.clear();
            this.displayNames.clear();
            for (int i = 0; i < nArray.length; ++i) {
                this.recordIDs.addElement(nArray[i]);
                this.displayNames.addElement(stringArray[i]);
            }
            tokenizer = null;
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.found = 0;
        }
    }

    private long getLong(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return -1L;
        }
        String string = new String(byArray);
        long l = 0L;
        int n = string.length();
        for (int i = 0; Character.isDigit(string.charAt(i)) && i < n; ++i) {
            l = l * 10L + (long)(string.charAt(i) - 48);
        }
        return l;
    }

    private void quickSort(int[] nArray, String[] stringArray, int n, int n2, boolean bl) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = (n + n2) / 2;
            String string = stringArray[n5];
            while (n3 <= n4) {
                while (n3 < n2 && this.check(stringArray[n3], string, bl) > 0) {
                    ++n3;
                }
                while (n4 > n && this.check(stringArray[n4], string, bl) < 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                String string2 = stringArray[n3];
                stringArray[n3] = stringArray[n4];
                stringArray[n4] = string2;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(nArray, stringArray, n, n4, bl);
            }
            if (n3 < n2) {
                this.quickSort(nArray, stringArray, n3, n2, bl);
            }
        }
    }

    private int check(String string, String string2, boolean bl) {
        if (!bl) {
            string = string.substring(0, string.indexOf(58));
            string2 = string2.substring(0, string2.indexOf(58));
        }
        return string.compareTo(string2);
    }
}

