/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.custom.ImageCanvas;
import com.ascendo.fitness.database.activity.ActivityDailyDatabase;
import com.ascendo.fitness.database.activity.ActivityMasterDatabase;
import com.ascendo.fitness.database.journal.JournalDatabase;
import com.ascendo.fitness.database.nutrition.NutritionDailyDatabase;
import com.ascendo.fitness.database.nutrition.NutritionMasterDatabase;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserGoalsRecord;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import com.ascendo.fitness.util.LineReader;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;

public final class FitnessMIDlet
extends MIDlet
implements CommandListener {
    public static FitnessMIDlet instance;
    private static Display display;
    private Gauge g;
    private boolean expired;
    public static boolean unitTypesLoaded;
    public static String[] SERVING_TYPES;
    public static String[] ACTIVITY_UNITS;

    public FitnessMIDlet() {
        display = Display.getDisplay((MIDlet)this);
        instance = this;
        DisplayController.init(display);
    }

    public void startApp() {
        block6: {
            ImageCanvas imageCanvas = new ImageCanvas("/images/Splash.png", 0xFFFFFF);
            display.setCurrent((Displayable)imageCanvas);
            long l = System.currentTimeMillis();
            this.initDB();
            display.setCurrent((Displayable)imageCanvas);
            this.expired = false;
            imageCanvas = null;
            if (!this.expired) {
                if (DefaultsRecord.userOption == 0) {
                    try {
                        if (!(UserSettingsRecord.loaded && UserGoalsRecord.loaded && DefaultsRecord.loaded)) {
                            DisplayController.message("Ascendo Fitness v2.3", "Before using Ascendo Fitness, initialize the values for Settings, Goals and Defaults", this);
                            break block6;
                        }
                        DisplayController.showMenu(0);
                    }
                    catch (Exception exception) {}
                } else {
                    DisplayController.showMenu(0);
                }
            }
        }
    }

    private void showWaitAlert(String string) {
        Alert alert = new Alert("Ascendo Fitness v2.3", string, null, AlertType.INFO);
        alert.setTimeout(-2);
        alert.setCommandListener((CommandListener)this);
        this.g = new Gauge(null, false, 100, 0);
        this.g.setLayout(0);
        this.g.setLabel(null);
        alert.setIndicator(this.g);
        display.setCurrent((Displayable)alert);
    }

    private void initDB() {
        RecordStore recordStore = null;
        boolean bl = false;
        try {
            recordStore = RecordStore.openRecordStore((String)"Nutrition", (boolean)false);
            bl = recordStore != null;
            recordStore.closeRecordStore();
            recordStore = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.showWaitAlert("Please wait, loading data...");
            UserSettingsRecord.load();
            this.g.setValue(20);
            UserGoalsRecord.load();
            this.g.setValue(42);
            DefaultsRecord.load();
            this.g.setValue(88);
            FitnessMIDlet.loadUnitTypes();
            this.g.setValue(100);
            return;
        }
        this.showWaitAlert("Please wait while initializing Nutrition and/or Activity database for the first time. \nThis is one-time process.\nThis may take several minutes depending on the device you are using.");
        String string = null;
        LineReader lineReader = new LineReader();
        byte[] byArray = null;
        try {
            NutritionMasterDatabase nutritionMasterDatabase = NutritionMasterDatabase.getInstance();
            this.g.setValue(15);
            lineReader.open("/data/Nutrition.adb");
            while ((string = lineReader.readLine()) != null) {
                if (string.charAt(0) == '#') continue;
                nutritionMasterDatabase.addRecord(string.getBytes());
            }
            lineReader.close();
            this.g.setValue(50);
            ActivityMasterDatabase activityMasterDatabase = ActivityMasterDatabase.getInstance();
            lineReader.open("/data/Activity.adb");
            while ((string = lineReader.readLine()) != null) {
                if (string.charAt(0) == '#') continue;
                activityMasterDatabase.addRecord(string.getBytes());
            }
            lineReader.close();
            this.g.setValue(80);
            recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            lineReader.open("/data/UnitTypes.adb");
            while ((string = lineReader.readLine()) != null) {
                if (string.charAt(0) == '#') continue;
                byArray = string.getBytes();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            lineReader.close();
            this.g.setValue(95);
            recordStore.closeRecordStore();
            lineReader.close();
            recordStore = null;
            lineReader = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        FitnessMIDlet.loadUnitTypes();
        this.g.setValue(100);
        recordStore = null;
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        NutritionMasterDatabase.getInstance().close();
        NutritionDailyDatabase.getInstance().close();
        ActivityMasterDatabase.getInstance().close();
        ActivityDailyDatabase.getInstance().close();
        JournalDatabase.getInstance().close();
        this.notifyDestroyed();
    }

    public static void exit() {
        instance.destroyApp(false);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == DisplayController.MESSAGE_ALERT && command == Alert.DISMISS_COMMAND) {
            DisplayController.showMenu(0);
            return;
        }
        if (command == Alert.DISMISS_COMMAND && this.expired) {
            FitnessMIDlet.exit();
        }
    }

    public static void loadUnitTypes() {
        if (unitTypesLoaded) {
            return;
        }
        unitTypesLoaded = true;
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        int n = 0;
        int n2 = 0;
        try {
            byte[] byArray;
            recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            recordEnumeration = recordStore.enumerateRecords(new RecordFilter(){

                public boolean matches(byte[] byArray) {
                    return byArray[0] == 83;
                }
            }, null, false);
            n2 = recordEnumeration.numRecords();
            if (n2 > 0) {
                SERVING_TYPES = new String[n2];
                n = 0;
                while (recordEnumeration.hasNextElement()) {
                    byArray = recordEnumeration.nextRecord();
                    FitnessMIDlet.SERVING_TYPES[n++] = new String(byArray, 2, byArray.length - 2);
                }
            }
            recordEnumeration.destroy();
            recordEnumeration = null;
            recordEnumeration = recordStore.enumerateRecords(new RecordFilter(){

                public boolean matches(byte[] byArray) {
                    return byArray[0] == 65;
                }
            }, null, false);
            n2 = recordEnumeration.numRecords();
            if (n2 > 0) {
                ACTIVITY_UNITS = new String[n2];
                n = 0;
                while (recordEnumeration.hasNextElement()) {
                    byArray = recordEnumeration.nextRecord();
                    FitnessMIDlet.ACTIVITY_UNITS[n++] = new String(byArray, 2, byArray.length - 2);
                }
            }
            recordEnumeration.destroy();
            recordEnumeration = null;
            recordStore.closeRecordStore();
            recordStore = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        unitTypesLoaded = false;
    }
}

