/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness;

import com.ascendo.fitness.custom.YesNoAlert;
import com.ascendo.fitness.database.activity.ActivityDailyDatabase;
import com.ascendo.fitness.database.journal.JournalDatabase;
import com.ascendo.fitness.database.nutrition.NutritionDailyDatabase;
import com.ascendo.fitness.forms.DeleteHelper;
import com.ascendo.fitness.forms.activity.ActivityEditHelper;
import com.ascendo.fitness.forms.activity.ActivitySearchForm;
import com.ascendo.fitness.forms.activity.ActivityTotalForm;
import com.ascendo.fitness.forms.activity.ActivityTypeForm;
import com.ascendo.fitness.forms.assistants.BMIForm;
import com.ascendo.fitness.forms.assistants.HealthyAndIdealWeightForm;
import com.ascendo.fitness.forms.assistants.HeartRateForm;
import com.ascendo.fitness.forms.assistants.MetabolismForm;
import com.ascendo.fitness.forms.journal.JournalEditHelper;
import com.ascendo.fitness.forms.journal.JournalEntryForm;
import com.ascendo.fitness.forms.nutrition.NutritionEditHelper;
import com.ascendo.fitness.forms.nutrition.NutritionSearchForm;
import com.ascendo.fitness.forms.nutrition.NutritionTotalForm;
import com.ascendo.fitness.forms.nutrition.NutritionTypeForm;
import com.ascendo.fitness.forms.others.AboutForm;
import com.ascendo.fitness.forms.others.DefaultsForm;
import com.ascendo.fitness.forms.others.HelpForm;
import com.ascendo.fitness.forms.others.UserGoalsForm;
import com.ascendo.fitness.forms.others.UserSettingsForm;
import com.ascendo.fitness.forms.progress.CaloriesBurnedGraph;
import com.ascendo.fitness.forms.progress.CaloriesIntakeGraph;
import com.ascendo.fitness.forms.progress.CarbohydratesIntakeGraph;
import com.ascendo.fitness.forms.progress.FatsIntakeGraph;
import com.ascendo.fitness.forms.progress.ProteinsIntakeGraph;
import com.ascendo.fitness.forms.progress.WeightGraph;
import com.ascendo.fitness.menu.MenuCanvas;
import com.ascendo.fitness.menu.MenusDatabase;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public final class DisplayController {
    private static Display display;
    public static int DISPLAY_SLEEP_DELAY;
    public static Alert MESSAGE_ALERT;

    public static void init(Display display) {
        DisplayController.display = display;
    }

    public static void showMenu(int n) {
        DisplayController.cleanForms();
        DisplayController.show((Displayable)new MenuCanvas(MenusDatabase.menus, n));
    }

    private static void cleanForms() {
        Displayable displayable = display.getCurrent();
        if (displayable != null && displayable instanceof Form) {
            try {
                ((Form)displayable).deleteAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void showForm(int n) {
        DisplayController.cleanForms();
        switch (n) {
            case -101: {
                DisplayController.show((Displayable)new NutritionSearchForm(10));
                break;
            }
            case -102: {
                new NutritionEditHelper().doIt();
                break;
            }
            case -103: {
                DisplayController.show((Displayable)new DeleteHelper(NutritionDailyDatabase.getInstance(), "Delete By Date", 1));
                break;
            }
            case -104: {
                DisplayController.show((Displayable)new NutritionTypeForm(""));
                break;
            }
            case -105: {
                DisplayController.show((Displayable)new NutritionSearchForm(30));
                break;
            }
            case -106: {
                DisplayController.show((Displayable)new NutritionSearchForm(20));
                break;
            }
            case -107: {
                DisplayController.show((Displayable)new NutritionTotalForm(""));
                break;
            }
            case -201: {
                DisplayController.show((Displayable)new ActivitySearchForm(10));
                break;
            }
            case -202: {
                new ActivityEditHelper().doIt();
                break;
            }
            case -203: {
                DisplayController.show((Displayable)new DeleteHelper(ActivityDailyDatabase.getInstance(), "Delete By Date", 2));
                break;
            }
            case -204: {
                DisplayController.show((Displayable)new ActivityTypeForm(""));
                break;
            }
            case -205: {
                DisplayController.show((Displayable)new ActivitySearchForm(30));
                break;
            }
            case -206: {
                DisplayController.show((Displayable)new ActivitySearchForm(20));
                break;
            }
            case -207: {
                DisplayController.show((Displayable)new ActivityTotalForm());
                break;
            }
            case -301: {
                DisplayController.show((Displayable)new JournalEntryForm(40));
                break;
            }
            case -302: {
                new JournalEditHelper().doIt();
                break;
            }
            case -303: {
                DisplayController.show((Displayable)new DeleteHelper(JournalDatabase.getInstance(), "Delete By Date", 3));
                break;
            }
            case -601: {
                DisplayController.show((Displayable)new UserSettingsForm());
                break;
            }
            case -602: {
                DisplayController.show((Displayable)new UserGoalsForm());
                break;
            }
            case -603: {
                DisplayController.show((Displayable)new DefaultsForm());
                break;
            }
            case -604: {
                DisplayController.show((Displayable)new HelpForm());
                break;
            }
            case -605: {
                DisplayController.show((Displayable)new AboutForm());
                break;
            }
            case -404: {
                DisplayController.show((Displayable)new CaloriesIntakeGraph());
                break;
            }
            case -405: {
                DisplayController.show((Displayable)new CaloriesBurnedGraph());
                break;
            }
            case -402: {
                DisplayController.show((Displayable)new WeightGraph());
                break;
            }
            case -406: {
                DisplayController.show((Displayable)new ProteinsIntakeGraph());
                break;
            }
            case -407: {
                DisplayController.show((Displayable)new CarbohydratesIntakeGraph());
                break;
            }
            case -408: {
                DisplayController.show((Displayable)new FatsIntakeGraph());
                break;
            }
            case -501: {
                DisplayController.show((Displayable)new HealthyAndIdealWeightForm(10));
                break;
            }
            case -502: {
                DisplayController.show((Displayable)new HealthyAndIdealWeightForm(20));
                break;
            }
            case -505: {
                DisplayController.show((Displayable)new MetabolismForm());
                break;
            }
            case -503: {
                DisplayController.show((Displayable)new BMIForm());
                break;
            }
            case -504: {
                DisplayController.show((Displayable)new HeartRateForm());
            }
        }
    }

    public static void show(Displayable displayable) {
        if (!(displayable instanceof Alert) && !(displayable instanceof YesNoAlert)) {
            DisplayController.cleanForms();
        }
        display.setCurrent(displayable);
    }

    public static void error(String string, String string2) {
        Alert alert = new Alert(string, string2, null, AlertType.ERROR);
        alert.setTimeout(-2);
        DisplayController.show((Displayable)alert);
    }

    public static void message(String string, String string2, CommandListener commandListener) {
        if (MESSAGE_ALERT == null) {
            MESSAGE_ALERT = new Alert(string, string2, null, AlertType.INFO);
            MESSAGE_ALERT.setTimeout(-2);
        }
        MESSAGE_ALERT.setTitle(string);
        MESSAGE_ALERT.setString(string2);
        MESSAGE_ALERT.setCommandListener(commandListener);
        DisplayController.show((Displayable)MESSAGE_ALERT);
    }

    static {
        DISPLAY_SLEEP_DELAY = 500;
    }
}

