/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.util;

public final class IntVector {
    private int[] numbers = new int[10];
    private int numbersCount;
    private int capacityIncrement = 10;

    public int size() {
        return this.numbersCount;
    }

    public int intAt(int n) {
        if (n >= this.numbersCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.numbersCount);
        }
        return this.numbers[n];
    }

    public void removeIntAt(int n) {
        if (n >= this.numbersCount || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Invalid Index");
        }
        int n2 = this.numbersCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.numbers, n + 1, this.numbers, n, n2);
        }
        --this.numbersCount;
    }

    private void ensureCapacity(int n) {
        int n2 = this.numbers.length;
        if (n > n2) {
            int n3;
            int[] nArray = this.numbers;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.numbers = new int[n3];
            System.arraycopy(nArray, 0, this.numbers, 0, this.numbersCount);
        }
    }

    public void addElement(int n) {
        this.ensureCapacity(this.numbersCount + 1);
        this.numbers[this.numbersCount++] = n;
    }

    public void clear() {
        this.numbersCount = 0;
    }

    public int[] toArray() {
        int[] nArray = new int[this.numbersCount];
        System.arraycopy(this.numbers, 0, nArray, 0, this.numbersCount);
        return nArray;
    }
}

