/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.others;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import com.ascendo.fitness.util.ConversionUtils;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public final class UserSettingsForm
extends Form
implements CommandListener {
    private final TextField height1Field = new TextField("Height (" + FitnessObjects.HEIGHT1_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final TextField height2Field = new TextField("Height (" + FitnessObjects.HEIGHT2_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final TextField weightField = new TextField("Weight (" + FitnessObjects.WEIGHT_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final ChoiceGroup genderField = new ChoiceGroup("Gender: ", 4, FitnessObjects.GENDER_TYPES, null);
    private final TextField ageField = new TextField("Age: ", "1", 5, 2);
    private final TextField heartRateField = new TextField("Resting Heart Rate: ", "1", 5, 2);

    public UserSettingsForm() {
        super("User Settings");
        boolean bl = DefaultsRecord.measurement == 0;
        this.height1Field.setString("" + (bl ? UserSettingsRecord.height1US : UserSettingsRecord.height1Metric));
        this.height2Field.setString("" + (bl ? UserSettingsRecord.height2US : UserSettingsRecord.height2Metric));
        this.weightField.setString("" + (bl ? UserSettingsRecord.weightUS : UserSettingsRecord.weightMetric));
        this.genderField.setSelectedIndex(UserSettingsRecord.genderIndex, true);
        this.ageField.setString("" + UserSettingsRecord.age);
        this.heartRateField.setString("" + UserSettingsRecord.heartRate);
        this.append((Item)this.height1Field);
        this.append((Item)this.height2Field);
        this.append((Item)this.weightField);
        this.append((Item)this.genderField);
        this.append((Item)this.ageField);
        this.append((Item)this.heartRateField);
        this.addCommand(FitnessCommands.CANCEL_COMMAND);
        this.addCommand(FitnessCommands.SAVE_COMMAND);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.CANCEL_COMMAND) {
            DisplayController.showMenu(0);
        } else if (command == FitnessCommands.SAVE_COMMAND) {
            this.doSubmit();
        }
    }

    private void doSubmit() {
        boolean bl;
        String string = ConversionUtils.getInvalidField(this);
        if (string != null) {
            DisplayController.error(this.getTitle(), "Invalid (or No) value specified for " + string.substring(0, string.indexOf(58)));
            return;
        }
        int n = Integer.parseInt(this.height1Field.getString());
        int n2 = Integer.parseInt(this.height2Field.getString());
        boolean bl2 = bl = DefaultsRecord.measurement == 0;
        if (bl) {
            UserSettingsRecord.height1US = n;
            UserSettingsRecord.height2US = n2;
            UserSettingsRecord.height1Metric = ConversionUtils.toMeters(UserSettingsRecord.height1US, UserSettingsRecord.height2US);
            UserSettingsRecord.height2Metric = ConversionUtils.toCentimeters(UserSettingsRecord.height1US, UserSettingsRecord.height2US);
            UserSettingsRecord.weightUS = Integer.parseInt(this.weightField.getString());
            UserSettingsRecord.weightMetric = ConversionUtils.toKGs(UserSettingsRecord.weightUS);
        } else {
            UserSettingsRecord.height1Metric = n;
            UserSettingsRecord.height2Metric = n2;
            UserSettingsRecord.height1US = ConversionUtils.toFeets(UserSettingsRecord.height1Metric, UserSettingsRecord.height2Metric);
            UserSettingsRecord.height2US = ConversionUtils.toInches(UserSettingsRecord.height1Metric, UserSettingsRecord.height2Metric);
            UserSettingsRecord.weightMetric = Integer.parseInt(this.weightField.getString());
            UserSettingsRecord.weightUS = ConversionUtils.toLbs(UserSettingsRecord.weightMetric);
        }
        UserSettingsRecord.genderIndex = this.genderField.getSelectedIndex();
        UserSettingsRecord.age = Integer.parseInt(this.ageField.getString());
        UserSettingsRecord.heartRate = Integer.parseInt(this.heartRateField.getString());
        UserSettingsRecord.save();
        DisplayController.showMenu(0);
    }
}

