/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.others;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserGoalsRecord;
import com.ascendo.fitness.util.ConversionUtils;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public final class UserGoalsForm
extends Form
implements CommandListener {
    private final TextField weightField = new TextField("Weight (" + FitnessObjects.WEIGHT_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final TextField caloriesIntakeField = new TextField("Calories Intake/Day: ", "1", 5, 2);
    private final TextField caloriesBurnedField = new TextField("Calories Burned/Day: ", "1", 5, 2);
    private final TextField carbIntakeField = new TextField("Carbohydrates Intake/Day:", "1", 5, 2);
    private final TextField proteinIntakeField = new TextField("Proteins Intake/Day:", "1", 5, 2);
    private final TextField fatIntakeField = new TextField("Fats Intake/Day:", "1", 5, 2);

    public UserGoalsForm() {
        super("Goals");
        this.weightField.setString("" + (DefaultsRecord.measurement == 0 ? UserGoalsRecord.weightUS : UserGoalsRecord.weightMetric));
        this.caloriesIntakeField.setString("" + UserGoalsRecord.caloriesIntake);
        this.caloriesBurnedField.setString("" + UserGoalsRecord.caloriesBurned);
        this.carbIntakeField.setString("" + UserGoalsRecord.carbIntake);
        this.proteinIntakeField.setString("" + UserGoalsRecord.proteinIntake);
        this.fatIntakeField.setString("" + UserGoalsRecord.fatIntake);
        this.append((Item)this.weightField);
        this.append((Item)this.caloriesIntakeField);
        this.append((Item)this.caloriesBurnedField);
        this.append((Item)this.carbIntakeField);
        this.append((Item)this.fatIntakeField);
        this.append((Item)this.proteinIntakeField);
        this.addCommand(FitnessCommands.CANCEL_COMMAND);
        this.addCommand(FitnessCommands.SAVE_COMMAND);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.CANCEL_COMMAND) {
            DisplayController.showMenu(0);
        } else if (command == FitnessCommands.SAVE_COMMAND) {
            this.doSubmit();
        }
    }

    private void doSubmit() {
        String string = ConversionUtils.getInvalidField(this);
        if (string != null) {
            DisplayController.error(this.getTitle(), "Invalid (or No) value specified for " + string.substring(0, string.indexOf(58)));
            return;
        }
        if (DefaultsRecord.measurement == 0) {
            UserGoalsRecord.weightUS = Integer.parseInt(this.weightField.getString());
            UserGoalsRecord.weightMetric = ConversionUtils.toKGs(UserGoalsRecord.weightUS);
        } else {
            UserGoalsRecord.weightMetric = Integer.parseInt(this.weightField.getString());
            UserGoalsRecord.weightUS = ConversionUtils.toLbs(UserGoalsRecord.weightMetric);
        }
        UserGoalsRecord.caloriesIntake = Integer.parseInt(this.caloriesIntakeField.getString());
        UserGoalsRecord.caloriesBurned = Integer.parseInt(this.caloriesBurnedField.getString());
        UserGoalsRecord.carbIntake = Integer.parseInt(this.carbIntakeField.getString());
        UserGoalsRecord.proteinIntake = Integer.parseInt(this.proteinIntakeField.getString());
        UserGoalsRecord.fatIntake = Integer.parseInt(this.fatIntakeField.getString());
        UserGoalsRecord.save();
        DisplayController.showMenu(0);
    }
}

