/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms.assistants;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import com.ascendo.fitness.FitnessObjects;
import com.ascendo.fitness.database.others.DefaultsRecord;
import com.ascendo.fitness.database.others.UserSettingsRecord;
import com.ascendo.fitness.util.ConversionUtils;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public final class BMIForm
extends Form
implements CommandListener,
ItemStateListener {
    private final TextField height1Field = new TextField("Height (" + FitnessObjects.HEIGHT1_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final TextField height2Field = new TextField("Height (" + FitnessObjects.HEIGHT2_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final TextField weightField = new TextField("Weight (" + FitnessObjects.WEIGHT_UNIT_TYPES[DefaultsRecord.measurement] + "): ", "1", 5, 2);
    private final StringItem bmi = new StringItem("Body Mass Index: ", "1");

    public BMIForm() {
        super("Body Mass Index");
        boolean bl = DefaultsRecord.measurement == 0;
        this.height1Field.setString("" + (bl ? UserSettingsRecord.height1US : UserSettingsRecord.height1Metric));
        this.height2Field.setString("" + (bl ? UserSettingsRecord.height2US : UserSettingsRecord.height2Metric));
        this.weightField.setString("" + (bl ? UserSettingsRecord.weightUS : UserSettingsRecord.weightMetric));
        this.bmi.setText("" + UserSettingsRecord.height1US * UserSettingsRecord.height2US / UserSettingsRecord.weightUS);
        this.append((Item)this.height1Field);
        this.append((Item)this.height2Field);
        this.append((Item)this.weightField);
        this.append((Item)this.bmi);
        this.addCommand(FitnessCommands.BACK_COMMAND);
        this.setCommandListener(this);
        this.setItemStateListener(this);
        this.calculateBMI();
    }

    private void calculateBMI() {
        try {
            boolean bl = DefaultsRecord.measurement == 0;
            int n = Integer.parseInt(this.height1Field.getString());
            int n2 = Integer.parseInt(this.height2Field.getString());
            int n3 = Integer.parseInt(this.weightField.getString());
            if (n < 0 || n2 < 0 || n3 < 0) {
                throw new Exception();
            }
            int n4 = 0;
            if (bl) {
                n4 = (n * 12 + n2) * 254 / 100;
                n3 = ConversionUtils.toKGs(n3);
            } else {
                n4 = n2 + n * 100;
            }
            int n5 = n3 * 10000 / (n4 * n4);
            this.bmi.setText("" + n5);
        }
        catch (Exception exception) {
            this.bmi.setText("Invalid input(s).");
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.BACK_COMMAND) {
            DisplayController.showMenu(7);
        }
    }

    public void itemStateChanged(Item item) {
        this.calculateBMI();
    }
}

