/*
 * Decompiled with CFR 0.152.
 */
package com.ascendo.fitness.forms;

import com.ascendo.fitness.DisplayController;
import com.ascendo.fitness.FitnessCommands;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public abstract class SearchForm
extends Form
implements CommandListener {
    protected final TextField itemField;
    protected List matchingItemsList;
    protected final int mode;
    protected final int backMenu;
    protected final StringItem messageItem;
    private int messageItemIndex = -1;

    public SearchForm(int n, int n2) {
        super("");
        this.mode = n;
        this.backMenu = n2;
        this.messageItem = new StringItem("", "");
        this.itemField = new TextField("Item: ", "", 30, 0);
        this.append((Item)this.itemField);
        this.addCommand(FitnessCommands.BACK_COMMAND);
        this.addCommand(FitnessCommands.SUBMIT_COMMAND);
        this.setCommandListener(this);
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command == FitnessCommands.YES_COMMAND) {
            this.yes();
        } else if (command == FitnessCommands.NO_COMMAND) {
            this.no();
        } else if (command == FitnessCommands.BACK_COMMAND) {
            if (displayable == this) {
                DisplayController.showMenu(this.backMenu);
            } else {
                if (this.messageItemIndex != -1) {
                    this.delete(this.messageItemIndex);
                    this.messageItemIndex = -1;
                }
                System.out.println("SHOWING=" + this.size());
                DisplayController.showMenu(this.backMenu);
            }
        } else if (command == FitnessCommands.SUBMIT_COMMAND) {
            this.doSubmit();
        } else if (command == FitnessCommands.SELECT_COMMAND || command == List.SELECT_COMMAND) {
            this.doItemSelection(this.matchingItemsList.getSelectedIndex());
        } else if (command == FitnessCommands.DELETE_COMMAND) {
            this.doDelete(this.matchingItemsList.getSelectedIndex());
        }
    }

    private void doSubmit() {
        if (this.itemField.getString().trim().length() <= 0) {
            this.messageItem.setText("Please enter a value to search for.");
            if (this.messageItemIndex == -1) {
                this.messageItemIndex = this.append((Item)this.messageItem);
            }
            return;
        }
        if (this.messageItemIndex != -1) {
            this.delete(this.messageItemIndex);
            this.messageItemIndex = -1;
        }
        this.doSearch();
    }

    public abstract void doDelete(int var1);

    public abstract void yes();

    public abstract void no();

    protected abstract void doSearch();

    protected abstract void doItemSelection(int var1);
}

